function exportBatt(batt, spreadsheet_name)
%saveBattMap
% Export batt map to spreadsheet

spreadsheet_name = spreadsheet_name + ".xlsx";

% Main data
mainData = table('Size', [0 3], ...
    'VariableTypes', ["string", "double", "string"], ...
    'VariableNames', ["Main Parameters", "value", "unit"]);

mainData(end+1, :) = {"Full Name", "", ""};
mainData(end+1, :) = {"Nominal capacity", batt.capacity, "Ah"};
mainData(end+1, :) = {"Nominal voltage", batt.nomVolt, "V"};
mainData(end+1, :) = {"Nominal energy", batt.nomEnergy, "kWh"};
mainData(end+1, :) = {"Mass", batt.mass, "kg"};
mainData(end+1, :) = {"Maximum charge current", batt.minCurr, "A"};
mainData(end+1, :) = {"Maximum discharge current", batt.maxCurr, "A"};
mainData(end+1, :) = {"Inverter efficiency", batt.inverterEff, ""};
mainData(end+1, :) = {"Coulombic efficiency", batt.coulombicEff, ""};

% OCV and Req characteristics
charDataHeader = table("-", "ohm",  "V", 'VariableNames', ...
    ["SOC", "eqRes", "ocVolt"]);
charData = table(batt.ocVolt.GridVectors{1}(:), ...
    batt.eqRes.Values(:), batt.ocVolt.Values(:));

% Write to spreadsheet
writetable(mainData, spreadsheet_name, Sheet = "main")
writetable(charDataHeader, spreadsheet_name, Sheet = "characteristics")
writetable(charData, spreadsheet_name, Sheet = "characteristics", ...
    WriteVariableNames = false, Range = "A3")


end